<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/util.php";
    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../classi/Etichetta.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni", 1);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $etichetta = new Etichetta($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $etichetta = new Etichetta($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $tipo = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES);
            $etichetta->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $etichetta->setTipo($tipo);
            $idEtichetta = $etichetta->crea();
            if($tipo=="documento" && $idEtichetta>0) {
                $etichetta->stampaRigaEtichetta();
            }
            else if($idEtichetta>0) {
                $etichetta->stampaPulsanteEtichetta();
            }
            else {
                echo "Errore: esiste già un etichetta con questo nome";
            }
            break;
        case 'creaDaPaginaDettagliDocumento':
            $etichetta->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $etichetta->setTipo("documento");
            $idEtichetta = $etichetta->crea();
            
            if($idEtichetta>0) {
                $idDocumento = filter_input(INPUT_POST,"idDocumento",FILTER_SANITIZE_NUMBER_INT);
                $query = "INSERT INTO geecD_associazioneEtichetteDocumenti VALUES($idEtichetta,$idDocumento)";
                $geecomDb->eseguiQueryScrittura($query);
                $etichetta->stampaPulsanteEtichettaPrimary();
            }
            else {
                echo "Errore: esiste già un etichetta con questo nome";
            }
            break;
        case 'modifica':
            $etichetta->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $etichetta->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $etichetta->modifica();
            echo "ok";
            break;
        case 'elimina':
            $etichetta->elimina();
            echo "ok";
            break;
    }